libname q 'C:\SASCodeForBook\SASDataSets';

Data first; set q.complications; 
if surg=1;

	/* Surgical Complications for Table 14.3*/
Title 'Panel A Precert but not Miami Hospitals Influence Surgical Complications, Logistic Regression';
	proc logistic descending ;
	model comps = miamihsp precert/expb cl;
	freq count;
run;

Title 'Panel A Saturated Loglinear Model';
	Proc catmod data=first;
	weight count;
	model comps*miamihsp*precert =_response_;
	loglin 	comps|precert|miamihsp; 
run;

Title 'Panel A Model: Both Precert and Miami Hospitals Influence Surgical Complications';
	Proc catmod data=first;
	weight count;
	model comps*miamihsp*precert =_response_;
	loglin 	comps|precert comps|miamihsp; 
run;

Title 'Panel A Best Model: Precert but not Miami Hospitals Influence Surgical Complications';
Proc catmod data=first;
	weight count;
	model comps*miamihsp*precert =_response_;
	loglin 	comps|precert miamihsp; 
run;

Title 'Panel A Alternative Model: No variables interact with each other';
Proc catmod data=first;
	weight count;
	model comps*miamihsp*precert =_response_;
	loglin 	comps precert miamihsp; 
run;


		/*Obstetrical Complications for Table 14.3*/

Data second; set q.complications;
if surg=0;

Title 'Panel B Effects of Miami hospitals and precert on obstetrical complications, logistic regression';
	proc logistic descending ;
	model comps = miamihsp precert/expb cl;
	freq count;
run;

Title 'Panel B Saturated Loglinear Model';
	Proc catmod data=second;
	weight count;
	model comps*miamihsp*precert =_response_;
	loglin 	comps|precert|miamihsp; 
run;

Title 'Panel B Model: Both Precert and Miami Hospitals Influence Obstetrical Complications';
	Proc catmod data=second;
	weight count;
	model comps*miamihsp*precert =_response_;
	loglin 	comps|precert comps|miamihsp; 
run;

Title 'Panel B Model: Miami Hospitals Influence Surgical Complications';
Proc catmod data=second;
	weight count;
	model comps*miamihsp*precert =_response_;
	loglin 	comps|miamihsp precert; 
run;

Title 'Panel B Best Model: The variables do not interact with each other';
Proc catmod data=second;
	weight count;
	model comps*miamihsp*precert =_response_;
	loglin 	comps miamihsp precert; 
run;


/* Precert and Miami Hospitals influence Surgical and or obstetrical
		complications for Table 14.3*/
Data surgorobstetcomps;
input miamihsp precert comps count;
datalines;
1.00 1.00 1.00   95 
1.00 1.00 0.00 1038 
1.00 0.00 1.00   84 
1.00 0.00 0.00  966 
0.00 1.00 1.00  130 
0.00 1.00 0.00 1694 
0.00 0.00 1.00  102 
0.00 0.00 0.00 1577 
;
run;

data third; set surgorobstetcomps;
Title 'Panel c top of notes logistic regression model';
proc logistic descending data=third;
model comps = miamihsp precert/expb cl;
freq count;
run;

Title 'Saturated Loglinear Model';
Proc catmod data=third;
weight count;
model comps*miamihsp*precert =_response_;
loglin 	comps|precert|miamihsp; 
run;

Title 'Panel C Top Model: Both Precert and Miami Hospitals Influence Total Complications';
Proc catmod data=third;
weight count;
model comps*miamihsp*precert =_response_;
loglin 	comps|precert comps|miamihsp; 
run;

Title 'Panel C Top Best Model: Miami Hospitals but not Precert Influence Total Complications';
Proc catmod data=third;
weight count;
model comps*miamihsp*precert =_response_;
loglin 	comps|miamihsp precert; 
run;

Title 'Panel C Alternative Top Model: No variables interact with each other';
Proc catmod data=third;
weight count;
model comps*miamihsp*precert =_response_;
loglin 	comps precert miamihsp; 
run;

	/* Models across the first two panels of Table 14.3*/

Data fourth; set q.complications;

Title 'Panel C not reported bottom effect of predictors on complications';
proc logistic descending data=fourth;
model comps = miamihsp precert surg/expb cl;
freq count;
run;


Title 'Panel C Bottom estimates Saturated Loglinear Model';
Proc catmod data=fourth;
weight count;
model comps*surg*miamihsp*precert =_response_;
loglin 	comps|surg|miamihsp|precert; 
run;

Title 'Best Loglinear Model';
Proc catmod data=fourth;
weight count;
model surg*miamihsp*precert*comps =_response_;
loglin 	surg|precert|comps miamihsp|surg; 
run;


/* The SAS Code for Table 14.3 is now complete.  The loglinear SPSS code may be of interest.
	If so please see the SPSS folder for chapter 14.*/
/* This syntax in this file is copyright by Robert B. Smith,  2011 */
